/****************************************************************************
 *   $Id:: nmi.c 7227 2011-04-27 20:20:38Z usb01267                         $
 *   Project: NXP LPC11U6x NMI interrupt example
 *
 *   Description:
 *     This file contains NMI interrupt handler code example.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC11U6x.h"
#include "lpc11U6x_nmi.h"
#include "lpc11U6x_timer16.h"
#include "lpc11U6x_timer32.h"
#include "lpc11U6x_gpio.h"
#include "lpc11U6x_adc.h"
#include "lpc11U6x_dma.h"
#include "lpc11U6x_rtc.h"
#include "lpc11U6x_bod_wdt.h"

#if NMI_ENABLED
volatile uint32_t NMI_Counter[MAX_NMI_NUM];

/*****************************************************************************
** Function name:		NMI_Handler
**
** Descriptions:		NMI interrupt handler
** parameters:		None			 
** 						
** Returned value:	None
** 
*****************************************************************************/
void NMI_Handler( void )
{
  uint32_t regVal;

  regVal = LPC_SYSCON->NMISRC;
  regVal &=	~0x80000000;
  if ( regVal < MAX_NMI_NUM )
  {
    if ( regVal == PIN_INT0_IRQn )
    {
      PIN_INT0_IRQHandler();
    }
    else if ( regVal == PIN_INT1_IRQn )
    {
      PIN_INT1_IRQHandler();
    }
    else if ( regVal == PIN_INT2_IRQn )
    {
      PIN_INT2_IRQHandler();
    }
    else if ( regVal == PIN_INT3_IRQn )
    {
      PIN_INT3_IRQHandler();
    }
    else if ( regVal == PIN_INT4_IRQn )
    {
      PIN_INT4_IRQHandler();
    }
    else if ( regVal == PIN_INT5_IRQn )
    {
      PIN_INT5_IRQHandler();
    }
    else if ( regVal == PIN_INT6_IRQn )
    {
      PIN_INT6_IRQHandler();
    }
    else if ( regVal == PIN_INT7_IRQn )
    {
      PIN_INT7_IRQHandler();
    }
    else if ( regVal == GINT0_IRQn )
    {
      GINT0_IRQHandler();
    }
    else if ( regVal == GINT1_IRQn )
    {
      GINT1_IRQHandler();
    }
    else if ( regVal == CT16B0_IRQn )
    {
      CT16B0_IRQHandler();
    }
    else if ( regVal == CT16B1_IRQn )
    {
      CT16B1_IRQHandler();
    }
    else if ( regVal == CT32B0_IRQn )
    {
      CT32B0_IRQHandler();
    }
    else if ( regVal == CT32B1_IRQn )
    {
      CT32B1_IRQHandler();
    }
    else if ( regVal == USB_IRQ_IRQn )
    {
      USB_IRQHandler();
    }
    else if ( regVal == USB_FIQ_IRQn )
    {
      USB_FIQHandler();
    }
    else if ( regVal == ADC_A_IRQn )
    {
      ADC_A_IRQHandler();
    }
    else if ( regVal == RTC_IRQn )
    {
      RTC_IRQHandler();
    }
    else if ( regVal == BOD_WDT_IRQn )
    {
      BOD_WDT_IRQHandler();
    }
    else if ( regVal == DMA_IRQn )
    {
      DMA_IRQHandler();
    }
    else if ( regVal == ADC_B_IRQn )
    {
      ADC_B_IRQHandler();
    }
    else if ( regVal == USBWAKEUP_IRQn )
    {
      USBWAKEUP_IRQHandler();
    }
    NMI_Counter[regVal]++; 
  }
  return;
}

/*****************************************************************************
** Function name:		NMI_Init
**
** Descriptions:		NMI initialization
** parameters:			NMI number			 
** 						
** Returned value:		None
** 
*****************************************************************************/
void NMI_Init( uint32_t NMI_num )
{
  uint32_t i;

  for ( i = 0; i < MAX_NMI_NUM; i++ )
  {
    NMI_Counter[i] = 0x0;
  }
  LPC_SYSCON->NMISRC = 0x00000000;
  LPC_SYSCON->NMISRC = 0x80000000|NMI_num;
  return;
}

#endif
